%% This Code is designed to simulate the flow of gossip through a Barabasi-Albert network and an ER-network.
% First generate a BA-network as before

%Get things started
size=1000; %size of network
A = zeros(size); %initially empty adjacency matrix
degree_vector=zeros(1,size); %This vector will store the degree of each node
edges=0; %store the total number of edges in the graph

A(1,2)=1;
A(2,1)=1;%make first connection
degree_vector(1)=1; %update degree vector
degree_vector(2)=1;
edges=1; %update edge count

for i=3:size
    test = 2*edges*rand; %random # between 0 and sum of degrees  
    tally=0;
    for j=1:i-1
        tally=tally+degree_vector(j);
        if(tally>test)
            A(i,j)=1; %make the connection and update
            A(j,i)=1;
            degree_vector(i)=1;
            degree_vector(j)=degree_vector(j)+1;
            edges=edges+1;
            break;
        end
    end
end

figure(1)
H = graph(A(1:size,1:size));
plot(H,'Layout','force')
set(gca, 'FontSize', 1);


%% Secondly, generate an ER network with the same number of anodes and average degree 2
size=1000;
ER=zeros(size);
%calculate the probability that an edge exists
av_degree=2;
p_exists=av_degree/(size-1); %small correction to the probability, not that important
for i = 1:size
    for j=i+1:size %don't test twice! And don't generate self-links.
        if(rand <p_exists) %generate a link with prob p_exists
            ER(i,j) = 1; %update both parts of adjacency matrix.
            ER(j,i)=1;
        end
    end
end
figure(2)
H = graph(ER(1:size,1:size));
plot(H,'Layout','force')
set(gca, 'FontSize', 1);

%% Simulate gossip spreading on the ER network for 20 steps
numsteps=20;
%declare vectors indicating who has heard the gossip
gossip_heard=zeros(1,size);
%One person starts gossip
source=randi([1,size]);
gossip_heard(source)=1;

%Track total people who have heard the gossip
total_spread=[0,1];

for n=1:numsteps %simulate for this many steps
    %In a single step, a person who has heard the gossip passes on the
    %information to all adjacent nodes. Implement this in a separate
    %function
    gossip_heard=spread_gossip(ER,gossip_heard);
    total_spread=[total_spread;n,sum(gossip_heard)];
end
hold on 
figure(3)
plot(total_spread(:,1), total_spread(:,2))
set(gca, 'FontSize', 20);

%% Simulate gossip spreading on the BA network for 20 steps
%declare vectors indicating who has heard the gossip
gossip_heard=zeros(1,size);
%One person starts gossip
source=randi([1,size]);
gossip_heard(source)=1;

%Track total people who have heard the gossip
total_spread=[0,1];

for n=1:numsteps %simulate for this many steps
    %In a single step, a person who has heard the gossip passes on the
    %information to all adjacent nodes. Implement this in a separate
    %function
    gossip_heard=spread_gossip(A,gossip_heard);
    total_spread=[total_spread;n,sum(gossip_heard)];
end
hold on 
figure(4)
plot(total_spread(:,1), total_spread(:,2))
set(gca, 'FontSize', 20);
